<?php

namespace App\Models;

use CodeIgniter\Model;

class UserAuthGroupModel extends Model
{
    protected $table = 'usc_user_auth_group';
    protected $primaryKey = 'id';

    protected $allowedFields = ['user_id', 'group_id', 'user_type', 'status'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';



    public function getAll()
    {
        $builder = $this->db->table('usc_user_auth_group as ug');
        $builder->select('ug.*, email, first_name, last_name, g.name as group');
        $builder->join('usc_users as u', 'u.id = ug.user_id');
        $builder->join('usc_user_groups as g', 'g.id = ug.group_id');
        $builder->where('ug.deleted_at', null);
        return $result = $builder->get()->getResult();
    }

    //Check User Group or Role of Access.
    public function login($id)
    {
        $builder = $this->db->table('usc_user_auth_group as ug');
        $builder->select('ug.*, email, first_name, last_name, g.name as group');
        $builder->join('usc_users as u', 'u.id = ug.user_id');
        $builder->join('usc_user_groups as g', 'g.id = ug.group_id');
        $builder->where('ug.deleted_at', null);
        $builder->where('ug.status', '1');
        $builder->where('ug.user_type', 'admin');
        $builder->where('user_id', $id);
        return $result = $builder->get()->getRow();
    }

    public function findGrpId($id)
    {
        $builder = $this->db->table('usc_user_auth_group');
        $builder->where('group_id', $id);
        return $result = $builder->get()->getRow();
    }
    public function findUsrId($id)
    {
        $grps = [2,3,12];
        $builder = $this->db->table('usc_user_auth_group');
        $builder->where('deleted_at', null);
        $builder->where('user_id', $id);
        $builder->whereIn('group_id', $grps);
        return $result = $builder->get()->getRow();
    }
    public function getUser($id)
    {
        $builder = $this->db->table('usc_user_auth_group as ug');
        $builder->select('ug.*, email, first_name, last_name, g.name as group');
        $builder->join('usc_users as u', 'u.id = ug.user_id');
        $builder->join('usc_user_groups as g', 'g.id = ug.group_id');
        $builder->where('ug.id', $id);
        return $result = $builder->get()->getRow();
    }
    public function updateUser($id)
    {
        $builder = $this->db->table('usc_user_auth_group as ug');
        $builder->where('id', $id);
		$builder->update($data);
        $result = $builder->get()->getRow();
		return $result;
    }
    public function getUserGroupsByTenantId($id)
    {
        $grps = [3,12,13];
        $builder = $this->db->table('usc_user_auth_group as ug');
        $builder->join('usc_users as u', 'u.id = ug.user_id');
        $builder->join('usc_user_groups as g', 'g.id = ug.group_id');
        $builder->select('ug.*, email,  first_name, last_name, g.name as group');
        $builder->where('ug.deleted_at', null);
        $builder->whereIn('g.id', $grps );
        $builder->where('u.tenant_id', $id);
        return $result = $builder->get()->getResult();
    }
    //Display specifically Managers, Attendants
    public function showOnlyManagersAttendants($id, $br)
    {
        $grps = [3,12];
        $builder = $this->db->table('usc_user_auth_group as ug');
        $builder->select('ug.*, email,  first_name, last_name, g.name as group');
        $builder->join('usc_users as u', 'u.id = ug.user_id');
        $builder->join('usc_user_groups as g', 'g.id = ug.group_id');
        $builder->where('ug.deleted_at', null);
        $builder->whereIn('g.id', $grps );
        $builder->where('u.tenant_id', $id);
        $builder->where('u.branch_id', $br);
        return $result = $builder->get()->getResult();
    }

    public function countUsersByRole($tId)
    {
        $grps = [2,3,12];
        $builder = $this->db->table('usc_user_auth_group as uag');
        $builder->join('usc_users as u', 'u.id = uag.user_id');
        $builder->where('uag.deleted_at', null);
        $builder->whereIn('group_id', $grps );
        $builder->where('u.tenant_id', $tId);
        $results = $builder->countAllResults();
        return $results;
    }

    //Limit Tenant ID creation of Managers and Attendants on Free and Startup plan
    public function limitUsersAsManagerAttendant($user)
    {
        $grps = [3,12];
        $builder = $this->db->table('usc_user_auth_group as ug');
        $builder->join('subscription as s', 's.user_id=ug.user_id');
        $builder->whereIn('group_id', $grps);
        $builder->where('ug.group_id', $user);
        $results = $builder->countAllResults();
        return $results;

    }

    //Get Tenant's Users Admin, Managers, Attendants
    public function getTenantzUsers($tId)
    {
        $grps = [2,3,12];
        $builder = $this->db->table('usc_user_auth_group as ug');
        $builder->select('ug.*, email,  first_name, last_name, g.name as group, ul.created_at as last_login');
        $builder->join('usc_users as u', 'u.id = ug.user_id');
        $builder->join('usc_user_groups as g', 'g.id = ug.group_id');
        $builder->join('user_auth_login as ul', 'ul.user_id=ug.user_id');
        $builder->where('ug.deleted_at', null);
        $builder->whereIn('g.id', $grps );
        $builder->where('u.tenant_id', $tId);
        return $result = $builder->get()->getResult();
    }

}