<?php

namespace App\Models;

use CodeIgniter\Model;

class StateModel extends Model
{
    protected $table = 'states';
    protected $primaryKey = 'id';

    protected $allowedFields = [ 'name', 'slug', 'country_id', 'status'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;

    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';
    
    public function getAll()
    {
        $builder = $this->db->table('states');
        return $result = $builder->get()->getResult();
    }

}