<?php

namespace App\Models;

use CodeIgniter\Model;

class NotificationsModel extends Model
{
    protected $table = 'notifications';
    protected $primaryKey = 'id';

    protected $allowedFields = ['message', 'user_id', 'status', 'notification_type', 'created_by', 'updated_by', 'updated_at'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;

    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';


    //Latest Activities
    public function getLatestActivities($user)
    {
        $builder = $this->db->table('notifications as n')
                ->select('n.*, first_name, last_name')
                ->join('users as u', 'u.id=n.created_by', 'left')
                ->where('n.deleted_at', null)
                ->where('n.user_id', $user)
                ->orderBy('n.id', 'DESC')
                ->limit(5);
        return $result = $builder->get()->getResult();
    }

    // Get total unread notifications for a user
    public function getTotalUserAlerts($userId)
    {
        return $this->where('user_id', $userId)
                    ->where('status', 0)
                    ->where('deleted_at IS NULL')
                    ->countAllResults();
    }



    
}