<?php

namespace App\Models;

use CodeIgniter\Model;

class CountryModel extends Model
{
    protected $table = 'usc_countries';
    protected $primaryKey = 'id';

    /**
     * Updated allowedFields to match the actual columns in usc_countries table.
     */
    protected $allowedFields = ['sortname', 'name', 'slug', 'phoncode', 'status', 'currency_symbol', 'currency_code', 'currency_name'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;

    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    /**
     * Fetches all non-soft-deleted countries.
     * Uses the Model's findAll() method for clean, built-in logic.
     */
    public function getAll()
    {
        return $this->findAll();
    }

    /**
     * Fetches a single country by its ID.
     * Uses the Model's find() method, which respects soft deletes.
     *
     * @param int $id The ID of the country.
     * @return array|object|null
     */
    public function getById($id)
    {
        return $this->find($id);
    }
}
