<?php

namespace App\Models;

use CodeIgniter\Model;

class CityModel extends Model
{
    protected $table = 'cities';
    protected $primaryKey = 'id';

    protected $allowedFields = [ 'name', 'slug', 'state_id', 'status'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;

    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    
    public function getAll()
    {
        $builder = $this->db->table('cities');
        return $result = $builder->get()->getResult();
    }

}