<?php

namespace App\Models;

use CodeIgniter\Model;

class BrandsModel extends Model
{
    protected $table = 'brands';
    protected $primaryKey = 'id';

    protected $allowedFields = ['name', 'photo', 'status', 'description', 'created_by', 'updated_by', 'updated_at'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';


    //Get all Branches
    public function getAll()
    {
        $builder = $this->db->table('brands');
        $builder->where('deleted_at', null);
		$result = $builder->get()->getResult();
		return $result;
    }

}