<?php

//Capture website Hits - Admin results
    // application/helpers/hits_helper.php

function log_hit($request, $CI)
{
    // Now you can use $request instead of $CI->request
    $ip_address = $request->getIPAddress();
    $user_agent =  $_SERVER['HTTP_USER_AGENT'];
    $url = current_url();
    $message = "Website hit from IP address $ip_address for URL $url";
    log_message('info', $message);

    $cacheKey = 'hit_count_' . date('Y-m-d');
    $hitCount = (int)cache($cacheKey) + 1;
    cache()->save($cacheKey, $hitCount, 86400);

    // Get to find hits for a particular URL
    $getHits = $CI->webtrafficModel->where('url', $url)->first($url);
    if (!empty($getHits['hits'])) {
        $hit = $getHits['hits'] + 1;
    } else {
        $hit = 1;
    }

    // Save the Hits in Db
    $traffData = [
        'user_agent' => $user_agent,
        'ip'         => $ip_address,
        'url'        => $url,
        'hits'       => $hit,
    ];
    $CI->webtrafficModel->save($traffData);
}
