<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class StripTagsFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        $post = $request->getPost();
        array_walk_recursive($post, function(&$value) {
            $value = strip_tags($value);
        });
        $request->setGlobal('post', $post);
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // No action needed after response
    }
}