<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class ContactFormFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        if ($request->getMethod() === 'post' && strpos($request->uri->getPath(), 'submit-contact') !== false) {
            $security = \Config\Services::security();
            
            if (!$security->checkToken($request->getPost($security->getTokenName()))) {
                return redirect()
                    ->to(base_url('contact-us'))
                    ->with('error', 'Invalid form submission. Please try again.');
            }
        }
        return;
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Do nothing after
    }
}