<?php

//namespace App\Middleware;
namespace App\Filters;

use Closure;
use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class CheckMultipleLogins implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        $session = \Config\Services::session();
        
        //Models for Login
        $authloginModel             = new \App\Models\AuthLoginModel(); 
       
        $check_for_doubleLogins = $authloginModel->chkIsAlive($session->get('logged_user'));
		if(!$check_for_doubleLogins)
		{
			$session->remove('logged_user');
			$session->remove('loggedIn', true);
			$session->destroy();
			return redirect()->to('multiple-logins/detected');
            
		}

        return $request;
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        return $response;
    }
}
