<?php

namespace App\Controllers\Front;

use App\Controllers\BaseController;
use Modules\ForexExchange\Models\ForexExchangeModel;

class Services extends BaseController
{
    public $forexExchangeModel;

    public function __construct()
    {
        $this->forexExchangeModel = new ForexExchangeModel();
    }

    public function index($slug = null)
    {
        // Load helper for emphasized text rendering
        helper('ltcms');
        
        if (empty($slug)) {
            return redirect()->to('/');
        }

        // Get the context from the current URL (personal or business)
        $currentURL = current_url();
        $context = (strpos($currentURL, '/personal/') !== false) ? 'personal' : 'business';
        
        // Get post by alias/slug and context
        $post = $this->postsModel
            ->where('alias', $slug)
            ->where('nav_context', $context)
            ->where('status', 'published')
            ->where('deleted_at', null)
            ->first();
        
        if (empty($post)) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }
        
        // Get blocks from database
        $blocks = $this->postBlocksModel->getPostBlocks($post['id']);
          // Get hero banner for Personal Banking page
        $data['hero_banner'] = $this->bannersModel->getPageHeroBannerByUrl($post['menu_link']);
        
        
        // Convert blocks to templateData format for existing templates
        $data['templateData'] = $this->convertBlocksToTemplateData($blocks, $post);
        $data['page'] = $post;
        
        // Check if foreign currency service - load forex rates (limit to 5)
        if (stripos($post['alias'], 'foreign-currency') !== false) {
            $rates = $this->forexExchangeModel->getActiveRates();
            $data['forex_rates'] = array_slice($rates, 0, 5);
            // $data['forex_last_updated'] = !empty($data['forex_rates']) ?
            //     date('F j, Y', strtotime($data['forex_rates'][0]['updated_at'])) :
            //     date('F j, Y');



                 $data['forex_last_updated'] = !empty($data['forex_rates']) ?
            date('F j, Y', strtotime($data['forex_rates'][0]->updated_at)) :
            date('F j, Y');
        }
        
        // Pass post data
        $data['title'] = $post['title'] . ' - ABC Capital Bank';
        $data['tagline'] = $post['excerpt'] ?? '';
        $data['description'] = $post['metadesc'] ?? $post['excerpt'] ?? '';
        $data['keywords'] = $post['metakey'] ?? '';
        $data['page_type'] = $post['nav_context'] ?? 'personal';
        
        // Determine which template to use
        $template = $this->getServiceTemplate($post);
        
        return view($template, $data);
    }
    
    /**
     * Convert database blocks to templateData format
     */
    private function convertBlocksToTemplateData($blocks, $post)
    {
        
        
        foreach ($blocks as $block) {
            switch ($block['block_type']) {
                case 'overview':
                    $templateData['overview_title'] = $block['heading'];
                    $templateData['overview_title_emphasized'] = $block['title_emphasized'] ?? null;
                    $templateData['overview_content'] = $block['content'];
                    $templateData['overview_image'] = $block['photo'];

                    // For savings template - add info cards
                    $infoCards = [];
                    if (isset($block['items'])) {
                        foreach ($block['items'] as $item) {
                            if ($item['item_type'] === 'info_card') {
                                $infoCards[] = [
                                    'icon' => $item['icon'] ?? 'fas fa-star',
                                    'title' => $item['title'] ?? '',
                                    'description' => $item['description'] ?? ''
                                ];
                            }
                        }
                    }
                    if (!empty($infoCards)) {
                        $templateData['info_cards'] = $infoCards;
                    }
                    break;
                    
                case 'eligibility':
                    $eligibilityItems = [];
                    if (isset($block['items'])) {
                        foreach ($block['items'] as $item) {
                            $eligibilityItems[] = [
                                'title' => $item['title'] ?? '',
                                'description' => $item['description'] ?? ''
                            ];
                        }
                    }
                    
                    $templateData['qualifications'] = [
                        'title' => $block['heading'] ?? 'Eligibility Requirements',
                        'title_emphasized' => $block['title_emphasized'] ?? null,
                        'description' => $block['subtitle'] ?? 'Qualifications to open and maintain this account',
                        'items' => $eligibilityItems
                    ];
                    break;

                case 'comparison':
                    $balanceBars = [];
                    $interestItems = [];
                    if (isset($block['items'])) {
                        foreach ($block['items'] as $item) {
                            $type = $item['item_type'] ?? '';
                            if ($type === 'bar' || $type === 'balance_bar') {
                                // Use the stored width from database, fallback to calculated width
                                $width = $item['width'] ?? $this->calculateFallbackWidth($item);
                                
                                $balanceBars[] = [
                                    'label' => $item['title'] ?? ($item['label'] ?? ''),
                                    'class' => $item['icon'] ?? 'standard',
                                    'width' => $width,
                                    'text'  => $item['description'] ?? ($item['text'] ?? ''),
                                ];
                            } elseif ($type === 'interest_item' || $type === 'interest') {
                                $interestItems[] = [
                                    'label' => $item['title'] ?? ($item['label'] ?? ''),
                                    'rate'  => $item['description'] ?? ($item['rate'] ?? ''),
                                    'class' => $item['icon'] ?? 'standard',
                                ];
                            }
                        }
                    }
                    
                    if (!empty($balanceBars) || !empty($interestItems)) {
                        $templateData['visual'] = [
                            'balance' => [
                                'title' => $block['heading'] ?? 'Minimum Balance Comparison',
                                'bars'  => $balanceBars,
                            ],
                            'interest' => [
                                'title' => $block['subtitle'] ?? 'Interest Rate Advantage',
                                'items' => $interestItems,
                                'note'  => $block['content'] ?? '',
                            ],
                        ];
                    }
                    break;
                    
                case 'benefits':
                    $templateData['benefits'] = [
                        'title' => $block['heading'],
                        'title_emphasized' => $block['title_emphasized'] ?? null,
                        'subtitle' => $block['subtitle'],
                        'items' => []
                    ];
                    if (isset($block['items'])) {
                        foreach ($block['items'] as $item) {
                            $templateData['benefits']['items'][] = [
                                'icon' => $item['icon'],
                                'title' => $item['title'],
                                'description' => $item['description']
                            ];
                        }
                    }
                    break;
                    
                case 'features':
                    $templateData['feature_highlights'] = [];
                    if (isset($block['items'])) {
                        foreach ($block['items'] as $item) {
                            $templateData['feature_highlights'][] = [
                                'icon' => $item['icon'],
                                'title' => $item['title'],
                                'text' => $item['description']
                            ];
                        }
                    }
                    break;

                case 'process':
                    $templateData['process_steps'] = [];
                    if (isset($block['items'])) {
                        foreach ($block['items'] as $item) {
                            $templateData['process_steps'][] = [
                                'title' => $item['title'],
                                'description' => $item['description']
                            ];
                        }
                    }
                    $templateData['process_subtitle'] = $block['subtitle'] ?? '';
                    break;

                
            }
        }
        
        return $templateData;
    }
    
    /**
     * Calculate fallback width if not stored in database
     */
    private function calculateFallbackWidth($item)
    {
        $description = $item['description'] ?? '';
        
        // Try to extract numeric value for calculation
        if (preg_match('/UGX\s*([\d,]+)/', $description, $matches)) {
            $amount = (int) str_replace(',', '', $matches[1]);
            
            // Use Premium Savings (1,000,000) as 100% baseline
            if ($amount <= 50000) return '20%';
            if ($amount <= 100000) return '40%';
            if ($amount <= 1000000) return '100%';
        }
        
        // For currency types or fallback
        return '50%';
    }
    
    /**
     * Determine which template to use based on service group
     */
    private function getServiceTemplate($post)
    {
        // Check if post has specific template_id
        if (!empty($post['template_id'])) {
            // Map template IDs to your existing views
            $templateMap = [
                1 => 'website/pages/current_accounts_template', // Current accounts
                2 => 'website/pages/saving_accounts_template',  // Savings accounts
                3 => 'website/pages/loans_template',           
                
            ];
            
            if (isset($templateMap[$post['template_id']])) {
                return $templateMap[$post['template_id']];
            }
        }
        
        // Simplified: Use service_group for template selection
        $serviceGroupMap = [
            'current' => 'website/pages/current_accounts_template',
            'saving' => 'website/pages/saving_accounts_template',
            'loans' => 'website/pages/loans_template',
      
        ];
        
        return $serviceGroupMap[$post['service_group'] ?? 'general'] ?? 'website/pages/current_accounts_template';
    }
}