<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

//settings & Authetication
use App\Models\UserAuthGroupModel;
use App\Models\UserAuthOtpModel;
use App\Models\AuthLoginModel;
use App\Models\UserAuthTokenModel;
use App\Models\UserActivateTokensModel;
use App\Models\UserActivationAttemptsModel;
use App\Models\UserResetsAttemptsModel;
use App\Models\UsersModel;
use App\Models\NotificationsModel;
use App\Models\EmailsModel;
use App\Models\CountryModel;
use App\Models\StateModel;
use App\Models\CityModel;
use App\Models\CountryStateCityModel;



use Modules\Settings\Models\UserGroupsModel;
use Modules\Settings\Models\PermissionsModel;
use Modules\Settings\Models\UserPermissionsModel;
use Modules\Settings\Models\UserGroupPermissionsModel;
use Modules\Settings\Models\CompanySettingsModel;
use Modules\Settings\Models\PolicySettingsModel;
use Modules\Settings\Models\PaymentGatewaysModel;
use Modules\Settings\Models\PaymentMethodsModel;
use Modules\Settings\Models\ModuleSectionModel;
use Modules\Posts\Models\NavContextsModel;


//Posts & Pages
use Modules\Posts\Models\PostsModel;
use Modules\Posts\Models\PostsCategoryModel;
use Modules\Posts\Models\PostCommentsModel;
use Modules\Posts\Models\BlockDefinitionsModel;
use Modules\Posts\Models\ItemTypeDefinitionsModel;
use Modules\Posts\Models\BlockItemTypeRelationshipsModel;
use Modules\Posts\Models\PostBlocksModel;
use Modules\Posts\Models\PostBlockItemsModel;
use Modules\Posts\Models\ContentTypesModel;

use Modules\Posts\Models\ServiceGroupsModel;
use Modules\Posts\Models\PageTemplatesModel;
use Modules\Posts\Models\TagsModel;
use Modules\Posts\Models\PostTagsModel;


//Menus
use Modules\Menu\Models\MenusModel;
use Modules\Menu\Models\MenusCategoryModel;

//sliders & Banners
use Modules\Sliders\Models\SlidersCategoryModel;
use Modules\Sliders\Models\SlidersModel;
use Modules\Banners\Models\BannersModel;



//Forex Exchange
use Modules\ForexExchange\Models\ForexExchangeModel;

use Modules\CustomerCare\Models\SubjectAnswersModel;


//Team
use Modules\Team\Models\TeamModel;
use Modules\Team\Models\TeamCategoryModel;
use Modules\Team\Models\TeamMemberGalleryModel;

//Job
use Modules\Jobs\Models\JobsModel;
use Modules\Jobs\Models\JobCategoryModel;


//Downlaods
use Modules\Downloads\Models\DownloadsCategoryModel;
use Modules\Downloads\Models\DownloadsModel;

use Modules\CustomerCare\Models\CustomerFeedbackModel;
use Modules\CustomerCare\Models\FeedbackSubjectModel;



//Website
use App\Models\WebTrafficModel;

//Support

use CodeIgniter\I18n\Time;







/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 */
abstract class BaseController extends Controller
{
    /**
     * Instance of the main Request object.
     *
     * @var CLIRequest|IncomingRequest
     */
    protected $request;

    /**
     * An array of helpers to be loaded automatically upon
     * class instantiation. These helpers will be available
     * to all other controllers that extend BaseController.
     *
     * @var array
     */
    protected $helpers = [];
    protected $data = []; // Set default data array

    /**
     * Be sure to declare properties for any property fetch you initialized.
     * The creation of dynamic property is deprecated in PHP 8.2.
     */
    // protected $session;
    public $pager;
    public $validation;
    public $emailsModel;
    public $registerModel;
    public $usersModel;
    public $userauthgroupModel;
    public $authloginModel;
    public $userauthotpModel;
    public $userauthtokenModel;
    public $useractivatetokensModel;
    public $userresetsattemptsModel;
    public $useractivationattemptsModel;
	public $permissionsModel;
    public $usergroupsModel;
	public $userpermissionsModel;
	public $usergrouppermissionsModel;
    public $paymentgatewaysModel;
    public $paymentmethodsModel;
    public $policysettingsModel;
    public $companysettingsModel;
    public $modulesectionModel;
	public $departmentModel;
	public $countryModel;
	public $stateModel;
	public $cityModel;
	public $notificationsModel;
	public $productModel;
	public $productcategoryModel;
	public $customerModel;
    public $menuscategoryModel;
    public $menusModel;
    public $downloadscategoryModel;
    public $downloadsModel;
    public $postscategoryModel;
    public $postsModel;
    public $blockdefinitionsModel;
    public $itemtypedefinitionsModel;
    public $blockitemtyperelationshipsModel;
    public $postBlocksModel;
    public $postBlockItemsModel;
    public $contenttypesModel;
    public $servicegroupsModel;
    public $navContextsModel;
    public $pagetemplatesModel;
    public $tagsModel;
    public $posttagsModel;
    public $postcommentsModel;
	public $sliderscategoryModel;
    public $slidersModel;
    public $bannersModel;
    public $forexExchangeModel;
    public $teamModel;
    public $teamcategoryModel;
    public $teammembergalleryModel;
    public $webtrafficModel;
    public $customerfeedbackModel;
    public $feedbacksubjectModel;
    public $jobsModel;
    public $jobCategoryModel;   
    public $subjectAnswersModel;





    /**
     * @return void
     */
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);

        // Preload any models, libraries, etc, here.

        // E.g.: $this->session = \Config\Services::session();
        $this->validation 				= \Config\Services::validation();
		$this->session 					= \Config\Services::session();
		$this->pager 				 	= \Config\Services::pager();
        $this->usersModel               = new UsersModel();
		$this->userauthgroupModel       = new UserAuthGroupModel();
        $this->authloginModel           = new AuthLoginModel();
        $this->userauthotpModel         = new UserAuthOtpModel();
        $this->userauthtokenModel       = new UserAuthTokenModel();
        $this->useractivationattemptsModel = new UserActivationAttemptsModel();
        $this->useractivatetokensModel = new UserActivateTokensModel(); 
        $this->userresetsattemptsModel  = new UserResetsAttemptsModel();
		$this->notificationsModel		= new NotificationsModel();
		$this->emailsModel				= new EmailsModel();
		$this->countryModel 			= new CountryModel();
		$this->stateModel				= new StateModel();
		$this->cityModel				= new CityModel();
        $this->permissionsModel			= new PermissionsModel();
        $this->usergroupsModel          = new UserGroupsModel();
        $this->userpermissionsModel		= new UserPermissionsModel();
        $this->usergrouppermissionsModel = new UserGroupPermissionsModel();
        $this->paymentgatewaysModel     = new PaymentGatewaysModel();
        $this->paymentmethodsModel	    = new PaymentMethodsModel();
        $this->policysettingsModel	    = new PolicySettingsModel();
        $this->companysettingsModel	    = new CompanySettingsModel();
        $this->modulesectionModel       = new ModuleSectionModel();
        $this->menusModel               = new MenusModel();
        $this->menuscategoryModel       = new MenusCategoryModel();      
		
		$this->postsModel               = new PostsModel();
        $this->postscategoryModel       = new PostsCategoryModel();
        $this->tagsModel                = new TagsModel();
        $this->posttagsModel            = new PostTagsModel();
        $this->postcommentsModel        = new PostcommentsModel();
        $this->postBlocksModel          = new PostBlocksModel();
         $this->blockdefinitionsModel    = new BlockDefinitionsModel();
        $this->blockitemtyperelationshipsModel = new BlockItemtypeRelationshipsModel();
        $this->itemtypedefinitionsModel = new ItemTypeDefinitionsModel();
        $this->postBlockItemsModel      = new PostBlockItemsModel();
        $this->contenttypesModel        = new ContentTypesModel();
       
        $this->servicegroupsModel       = new ServiceGroupsModel();
        $this->pagetemplatesModel       = new PageTemplatesModel();
        $this->navContextsModel         = new NavContextsModel();
        

        $this->downloadscategoryModel     = new DownloadsCategoryModel();
        $this->downloadsModel             = new DownloadsModel();
     

        $this->sliderscategoryModel     = new SlidersCategoryModel();
        $this->slidersModel             = new SlidersModel();
        $this->bannersModel             = new BannersModel();
   
        $this->forexExchangeModel      = new ForexExchangeModel();

    

        $this->teamModel                = new TeamModel();
        $this->teamcategoryModel        = new TeamCategoryModel();
	    $this->teammembergalleryModel   = new TeamMemberGalleryModel();

    
        $this->customerfeedbackModel = new CustomerFeedbackModel(); 
        $this->feedbacksubjectModel = new FeedbackSubjectModel(); 

        $this->jobsModel = new JobsModel(); 
        $this->jobCategoryModel = new JobCategoryModel(); 


        $this->webtrafficModel          = new WebTrafficModel();

        $this->subjectAnswersModel      = new SubjectAnswersModel();

     

        // Provide commonly used view data so shared views (header, sidebar) don't
        // throw undefined variable notices when controllers forget to pass them.
        $userId = $this->session->get('logged_user');
        $this->data['mynotifications'] = 0;
        $this->data['userdata'] = null;
        $this->data['bcrumb'] = 'Home'; // Default breadcrumb
        $this->data['title'] = 'Dashboard'; // Default title
        if ($userId) {
            // getTotalUserAlerts returns the count of unread notifications for the user
            $this->data['mynotifications'] = $this->notificationsModel->getTotalUserAlerts($userId) ?? 0;
            // Provide user details for header/profile display
            $this->data['userdata'] = $this->authloginModel->getUserDetails($userId);
        }
    }
    
	//Generating Unique ID Number
    function generateUniqueId() {
        $uniqueId = '';
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $dashPositions = array(8, 13, 18, 23);
        
        for ($i = 0; $i < 32; $i++) {
          $uniqueId .= $characters[rand(0, strlen($characters) - 1)];
        }
        
        foreach ($dashPositions as $pos) {
          $uniqueId = substr_replace($uniqueId, '-', $pos, 0);
        }
        
        return $uniqueId;
    }

	function GUID()
	{
    if (function_exists('com_create_guid') === true)
    {
        return trim(com_create_guid(), '{}');
    }

    return sprintf('%04X%04X-%04X-%04X-%04X-%04X%04X%04X', mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(16384, 20479), mt_rand(32768, 49151), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535));
	}

    function generatePassword($length = 15) {
        $charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        $password = "";
        $charsetLength = strlen($charset);
    
        for ($i = 0; $i < $length; $i++) {
            $randomIndex = rand(0, $charsetLength - 1);
            $password .= $charset[$randomIndex];
        }
    
        return $password;
    }

     
    
    

    //Get Browser details
    function getBrowser()
    {
        $u_agent = $_SERVER['HTTP_USER_AGENT'];
        $bname = 'Unknown';
        $platform = 'Unknown';
        $version= "";

        if (preg_match('/linux/i', $u_agent)) {
            $platform = 'linux';
        } elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
            $platform = 'mac';
        } elseif (preg_match('/windows|win32/i', $u_agent)) {
            $platform = 'windows';
        }

        if(preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent)) 
        { 
            $bname = 'Internet Explorer'; 
            $ub = "MSIE"; 
        } 
        elseif(preg_match('/Firefox/i',$u_agent)) 
        { 
            $bname = 'Mozilla Firefox'; 
            $ub = "Firefox"; 
        } 
        elseif(preg_match('/Chrome/i',$u_agent)) 
        { 
            $bname = 'Google Chrome'; 
            $ub = "Chrome"; 
        } 
        elseif(preg_match('/Safari/i',$u_agent)) 
        { 
            $bname = 'Apple Safari'; 
            $ub = "Safari"; 
        } 
        elseif(preg_match('/Opera/i',$u_agent)) 
        { 
            $bname = 'Opera'; 
            $ub = "Opera"; 
        } 
        elseif(preg_match('/Netscape/i',$u_agent)) 
        { 
            $bname = 'Netscape'; 
            $ub = "Netscape"; 
        } 
        
        return $bname;
    }

    //Get IP Address Location
    function getLocationFromIP($ip)
    {
        // You can use a third-party service like IP Geolocation API
        $apiKey = 'd7404ee5ca8b478b9ed1881fd0e00eb1';
        $url = "https://api.ipgeolocation.io/ipgeo?apiKey={$apiKey}&ip={$ip}";
        $response = file_get_contents($url);
        $data = json_decode($response, true);
        
        return $data['country_name'] . ', ' . $data['state_prov'];
    }

    
    //Email Token for Account Activation
    function sendTokenEmail($clientEmail, $token)
    {
        $email = \Config\Services::email();
        $checkUser = $this->usersModel->where('email', $clientEmail)->first($clientEmail);
        $clientName =  $checkUser['first_name'].' '.$checkUser['last_name'];

        //Sending Email
        $emailTemplate = view('email_templates/account_activation_template', [
            'clientName'    => $clientName,
            'clientEmail'   => $clientEmail,
            'tokenUrl'      => base_url('account/activation/'.$token),
        ]);
        $email->setMailType('html');
        $email->setFrom('ithelp@abccapitalbank.co.ug', 'ABC Capital Bank');
        $email->setTo($clientEmail);
        $email->setSubject( 'Account Activation Link - ABC Capital Bank');
        $email->setMessage($emailTemplate);
        if ($email->send()) {
            return true;
        } else {
            return false;
        }
    }

    
    //Email OTP
    function sendOtpEmail($clientEmail, $otp)
    {
        $email = \Config\Services::email();
        $checkUser = $this->usersModel->verifyEmail($clientEmail);;
        $clientName =  $checkUser->first_name.' '.$checkUser->last_name;

        //Sending Email
        $emailTemplate = view('email_templates/otp_login_template', [
            'clientName'    => $clientName,
            'otp'           => $otp,
        ]);
        $email->setMailType('html');
        $email->setFrom('ithelp@abccapitalbank.co.ug', 'ABC Capital Bank');
        $email->setTo($clientEmail);
        $email->setSubject( 'Your One-time password (OTP) Login Code');
        $email->setMessage($emailTemplate);
        if ($email->send()) {
            return true;
        } else {
            return false;
        }
    }

    //Uzer Notification
    function sendUserNotifications($message, $notificationType, $created_by)
    {
        $this->notificationsModel->save([
			'message'           => $message,
			'receiver_id'       => $created_by,
			'notification_type' => $notificationType,
			'receiver_type'		=> 'client',
			'created_by'        => $created_by,
		]);
    }

    //Admin Notification
    function sendAdminNotifications($message, $notificationType, $createdBy)
    {
        $admins = $this->usersModel->getAdminUsers();
        foreach ($admins as $admin) {
            $this->notificationsModel->save([
                'message'           => $message,
                'user_id'           => $admin->id,
                'notification_type' => $notificationType,
                'created_by'        => $createdBy,
            ]);
        }
    }


    /**
     * Respond with a JSON formatted output.
     *
     * @param array|object $data
     * @param int $status
     * @return ResponseInterface
     */
    protected function respond($data, int $status = 200): ResponseInterface
    {
        return $this->response
                    ->setStatusCode($status)
                    ->setContentType("application/json")
                    ->setBody(json_encode($data));
    }

}
