<?php

namespace App\Controllers\Auth;

use CodeIgniter\Controller;
use Config\Services;
use App\Controllers\BaseController;



class Login extends BaseController
{
    public function index()
    {
        $this->data['title'] = 'Login - ABC CAPITAL BANK UGANDA LTD';

        return view('auth/login', $this->data);
    }
    public function login()
    {
        $this->data['title'] = 'Login - ABC CAPITAL BANK UGANDA LTD';

        //Param
        $this->data['sessionid'] = $this->GUID();
        $email = \Config\Services::email();
        $otp = rand(100000, 999999);

        $rules = [
            'email'      => ['label' => 'Username', 'rules' => 'required'],
            'password'		 => ['label' => 'Password', 'rules' => 'required'], 
        ];

        $throttler = \Config\Services::throttler();
        $regulate = $throttler->check('logins', 3, MINUTE);

        //Rate limit login
        if(!$regulate){
            $this->session->setFlashdata('error', 'You reached the <strong>maximum</strong> login attempts.', 3);
			return redirect()->to('/');
        }

        if(!$this->validate($rules)){
            $this->data['errors'] = $this->validator->getErrors();
            return view('auth/login', $this->data);
        }

        $clientEmail    = $this->request->getPost('email');
        $password       =  $this->request->getPost('password');
        $getUser        = $this->usersModel->where('email', $clientEmail)->first($clientEmail);
        //$checkGroup     = $this->userauthgroupModel->where('user_id', $getUser['id'])->first();
        //Verify Email
        if(!$getUser || !password_verify($password, $getUser['password'])  || $getUser['status'] != 'active'){
            session()->setTempdata('error', 'Invalid Email and Password combination', 3);
            return redirect()->to('back-pass/login');
        }
        
        //User send OTP and later create session.
        $browser = $this->getBrowser();
        $ip = $this->request->getIPAddress();
        $otp = rand(100000, 999999); // 6-digit OTP

        $this->userauthotpModel->saveOtp($getUser['id'], $otp, $browser, $ip);
        $this->sendOtpEmail($clientEmail, $otp);
        session()->setTempdata('success', "Welcome back <strong>".$getUser['first_name']."</strong>! Enter OTP to continue", 3);
        return redirect()->to('verify-otp/'.$getUser['id']);

        return view('auth/login', $this->data);
    }

    public function verifyOtp($id)
    {
        $this->data['title'] = 'Verify OTP';
        $this->data['userID'] = $id;
        
        $browser        = $this->getBrowser();
        $ip             = $this->request->getIPAddress();
        $sessionid      = $this->GUID();
        $admins         =$this->usersModel->getAdminUsers();
        
        if($this->request->getMethod() == 'POST')
        {
            $enteredOtp     = $this->request->getPost('otp');
            $checkUser 	    = $this->usersModel->where('id', $id)->first($id);
            $result         = $this->userauthgroupModel->where('user_id', $id)->first($id);

            if ($this->userauthotpModel->checkOtp($id, $enteredOtp)) {
                session()->set('logged_user', $sessionid);
                session()->set('loggedIn', true);
                //Session Table saved fields
                $sesndata = [
                    'user_id'       => $id,
                    'email'         => $checkUser['email'],
                    'ip_address'    => $this->request->getIPAddress(),
                    'token'         => $sessionid,
                    'user_agent'    => $this->getBrowser(),
                ];
                        
                //Notification
                $message = "User ".$checkUser['email']."  has logged in ";
                foreach($admins as $admin)
                {
                    $notification = [
                        'user_id'           => $admin->id,
                        'message'           => $message,
                        'notification_type' => 'security',
                        'created_by'        => $id,
                    ];
                    $this->notificationsModel->save($notification);
                }

                     if($result)
                {

                if($result['group_id'] ==6 || $result['group_id'] == 7 ){
                        $this->authloginModel->save($sesndata);
                        $this->session->setTempdata('success', "Welcome back, <strong>".$checkUser['first_name'] ."</strong>!", 3);
                        $this->successfulLogin($id, $browser, $ip);
                        return redirect()->to('/');
                        exit();
                    }elseif($result['group_id'] == 1 || $result['group_id'] == 2 || $result['group_id'] == 3 || $result['group_id'] == 5 || $result['group_id'] == 5){
                        $this->authloginModel->save($sesndata);
                        $this->session->setTempdata('success', "Welcome back, <strong>".$checkUser['first_name'] ."</strong>!", 3);
                        $this->successfulLogin($id, $browser, $ip);
                       return redirect()->to('administrator');
                        exit();
                    }else{
                        $this->session->setTempdata('error', 'Sorry! Your account is either <strong>suspended</strong> or Not existing. Contact Support', 3);
                        return redirect()->to('auth/login');
                    }



                }else{
                    session()->setTempdata('error', 'Sorry! Your account is <strong>suspended</strong>. Contact Support', 3);
                    return redirect()->to('auth/login');
                }
                
            } else {
                session()->setTempdata('error', 'Invalid OTP', 3);
            }
        }
        
        return view('auth/verify_otp', $this->data);
    }
    //Forgot Password
    public function forgotPassword()
    { 
       $this->data['title'] = 'Forgot Password - Enter Email Address';

        $hash = bin2hex(random_bytes(24));
        $ptoken = bin2hex(random_bytes(24));
        $validation =  \Config\Services::validation();
        $email = \Config\Services::email();
        $expiryTime = date('Y-m-d H:i:s', strtotime('+30 minutes'));
        $admins = $this->usersModel->getAdminUsers();

        $rules = [
            'email' => ['label'=>'Email', 'rules'=>'required']
        ];
        $userEmail = $this->request->getPost('email');

        if($this->request->getMethod() == 'POST')
        {
            if($this->validate($rules))
            {
                $checkUser = $this->usersModel->where('email', $userEmail)->first($userEmail);
                if($checkUser)
                {
                    $tokenData = [
                        'hashed_token'  => $hash,
                        'user_id'       => $checkUser['id'],
                        'ip_address'    => $this->request->getIPAddress(),
                        'expires'       => $expiryTime,
                    ];
                    if($this->userauthtokenModel->save($tokenData))
                    {
                        $clientName =  $checkUser['first_name'].' '.$checkUser['last_name'];
                        $clientEmail    = $userEmail;
                        $resetLink      = base_url()."password/reset=".$hash;


                        //Sending Email to Client
                        $emailTemplate = view('email_templates/reset_password_link_template', [
                            'clientName'      => $clientName,
                            'token'           => $hash,
                            'clientEmail'     => $clientEmail,
                            'resetLink'       => $resetLink,
                        ]);
                        $email->setMailType('html');
                        $email->setFrom('ithelp@abccapitalbank.co.ug', 'ABC Capital Bank');
                        $email->setTo($clientEmail);
                        $email->setSubject( 'Password Request - ABC Capital Bank');
                        $email->setMessage($emailTemplate); 
                        if($email->send())
                        {
                            //Log this request for password reset.
                            $message = $clientEmail."  made a password reset request at ".date('Y-m-d H:i:s');
                            foreach($admins as $admin)
                            {
                                $notification = [
                                    'receiver_id'       => $admin->id,
                                    'message'           => $message,
                                    'notification_type' => 'security',
                                    'created_by'        => $checkUser['id'],
                                ];
                                $this->notificationsModel->save($notification);
                            }
                            return redirect()->to('password/reset/done='.$ptoken);
                        }
                    }
                }else{
                    return redirect()->to('password/reset/done='.$ptoken);
                }
            }else{
                $this->data['errors'] = $this->validator->getErrors();
            }
        }
        return view('auth/forgot', $this->data);
    }

    //Reset Password
    public function resetPassword($token = null)
    { 
        //$this->data['code'] = bin2hex(random_bytes(24));
        $this->data['title'] = 'Reset Password';
        $checkToken = $this->userauthtokenModel->verifyToken($token);
        $getUser = $this->usersModel->where('id', $checkToken->user_id)->first($checkToken->user_id);
        if($token)
        {
            if(!empty($checkToken))
            {
               // Save password resets times for a user
               $resetTimes = [
                    'email'         => $getUser['email'],
                    'token'         => $token,
                    'ip_address'    => $this->request->getIPAddress(),
                    'user_agent'    => $this->getBrowser(),
                ];
                $this->userresetsattemptsModel->save($resetTimes);

                //Check for token Expiry
                $expired = (time() > strtotime($checkToken->expires));
                if(!$expired)
                {
                    $this->data['checkToken'] = $this->userauthtokenModel->verifyToken($token);
                    session()->setTempdata('success', 'You go ahead! Reset Password', 3);
                    return view('auth/reset_password', $this->data);
                }else
                {
                    session()->setTempdata('error', 'Sorry! Reset Password Token Expired or does not Exist', 3);
                    return redirect()->to('forgot-password');
                }
            }else
            {
                session()->setTempdata('error', 'Sorry! Reset Password Token Expired or does not Exist', 3);
                return redirect()->to('forgot-password');
            }
        }else
        {
            session()->setTempdata('error', 'Sorry! Reset Password Token Expired or does not Exist', 3);
            return redirect()->to('back-pass/login');
        }
        
    }

    //update password
    public function updatePassword()
    {
        $this->data['title'] = 'back-pass/login';
        $this->data['checkToken'] = $this->userauthtokenModel->verifyToken($this->request->getPost('token'));
        $admins = $this->usersModel->getAdminUsers();
        $checkToken = $this->userauthtokenModel->verifyToken($this->request->getPost('token'));

        if($this->request->getMethod() == 'POST')
        {
            $checkUser = $this->usersModel->where('id', $checkToken->user_id)->first($checkToken->user_id);
            $rules = [
                'password'		 	 	 => ['label' => 'Password', 'rules' => 'required|min_length[8]|max_length[18]|alpha_numeric_punct'],
                'cpass'				 	 => ['label' => 'Confirm Password', 'rules' => 'required|min_length[8]|max_length[20]|matches[password]'],
            ];
            if(!$this->validate($rules))
            {
                $this->data['errors'] = $this->validator->getErrors();
                return view('auth/reset_password', $this->data);
            }else
            {
                $password = password_hash($this->request->getVar('password'), PASSWORD_DEFAULT);
                $newPwd = [
                    'password' => $password,
                ];
                if($this->usersModel->updatePassword($checkToken->user_id, $password))
                {
                    //Need to update User Auth Token table - updated time.
                    $this->userauthtokenModel->updateOnToken($checkToken->id);

                    //Notification
                    $client  = $checkUser['first_name'].' '.$checkUser['last_name'];

                    $message = $client."  successfully reset password.";
                    foreach($admins as $admin)
                    {
                        $notification = [
                            'receiver_id'       => $admin->id,
                            'message'           => $message,
                            'notification_type' => 'security',
                            'created_by'        => $checkToken->user_id,
                        ];
                        $this->notificationsModel->save($notification);
                    }

                    session()->setTempdata('success', 'Password updated successfully', 3);
                    return redirect()->to('back-pass/login');
                }else
                {
                    session()->setTempdata('error', 'Sorry!, Unable to Change your password, Try again.', 3);
                    return redirect()->to(previous_url());
                }
            }
        }
        return view('auth/forgot', $this->data);
    }

    //Email OTP
    private function successfulLogin($id, $browser, $ip)
    {
        $email = \Config\Services::email();
        $checkUser = $this->usersModel->where('id', $id)->first($id);
        $clientName =  $checkUser['first_name'].' '.$checkUser['last_name'];

        //Sending Email
        $emailTemplate = view('email_templates/login_notification_template', [
            'clientName'    => $clientName,
            'browser'       => $browser,
            'ip'            => $ip,
        ]);
        $email->setMailType('html');
        $email->setFrom('ithelp@abccapitalbank.co.ug', 'ABC Capital Bank');
        $email->setTo($checkUser['email']);
        $email->setSubject( 'New login on your ABC Capital Admin account');
        $email->setMessage($emailTemplate);
        if ($email->send()) {
            return true;
        } else {
            return false;
        }
    }

    //Message received on sending password recovery email.
	public function sentPwd($token)
	{
        $this->data['title'] = 'Password Recovery Email Sent';
	    return view('auth/fp-msge', $this->data);
	}

}



