<?php

namespace App\Controllers\Auth;

use App\Controllers\BaseController;
use App\Models\RegisterModel;
use App\Models\SessionsModel;
use App\Models\UserModel;
use App\Models\CountryModel;
use App\Helpers;

class Register extends BaseController
{
    public $registerModel;
	public $countryModel;
    public function __construct(){
        
        helper('form', 'url');
		$this->registerModel 	= new RegisterModel();
        $this->session 			= \Config\Services::session();
		$this->email 			= \Config\Services::email();
		$this->validation 		= \Config\Services::validation();
		$this->countryModel 	= new CountryModel();
    }
    public function thx()
    {
        return view('auth/thank_you');
    }

	public function activate($vcode=null)
	{
		$data = [];
		$mydata = $this->registerModel->verifyCode($vcode);
		if($mydata)
		{
			//update user active status
			if($mydata->status == 'inactive')
			{
				$status = $this->registerModel->updateStatus($vcode);
						
				if($status==true)
				{
							
					$this->session->setTempdata('success', 'You account is now active, Please login.', 3);
                    return redirect()->to('login');
							
            	}else{
            				$this->session->setTempdata('error', 'Sorry! Unable to find your Account', 3);
            				return redirect()->to('login');
            	}
    		}else{
    			$this->session->setTempdata('error', 'Sorry! Unable to process your request.', 3);
    			return redirect()->to('login');
    		}
		
    	}else{
    	    $this->session->setTempdata('error', 'Sorry! Wrong activation code.', 3);
        	return redirect()->to('login');
    	}
	echo view('auth/login', $this->data);
	}
}
