<?php

namespace App\Controllers\Auth;

use App\Controllers\BaseController;
use CodeIgniter\Controller;
use Config\Services;


class AuthController extends BaseController 
{
	
	public function initController($request, $response, $logger)
    {
        parent::initController($request, $response, $logger);
        
        // Enable CSRF protection
        $this->helpers = array_merge($this->helpers ?? [], ['form']);
        
		$this->init();
    }

	public function init(){
		$this->data['validation'] = null;
		
		// First check if user is logged in
		if (!$this->session->get('loggedIn')) {
			return redirect()->to('back-pass/login');
		}
		
		// Get logged user ID
		$logged_user_id = $this->session->get('logged_user');
		if (!$logged_user_id) {
			$this->session->remove('loggedIn');
			return redirect()->to('back-pass/login');
		}
		
		// Get user details
		$userdata = $this->authloginModel->getUserDetails($logged_user_id);
		if (!$userdata) {
			$this->session->remove('logged_user');
			$this->session->remove('loggedIn');
			return redirect()->to('back-pass/login');
		}
		
		// Set user data
		$this->data['userdata'] = $userdata;
		$this->userdata = $userdata;
		
		// Set additional data
		$this->data['mynotifications'] = $this->notificationsModel->getTotalUserAlerts($userdata->user_id);
		$this->data['countries'] = $this->countryModel->getAll();
		$this->data['currencies'] = $this->countryModel->getAll(); // Use countries as currencies since we don't have a separate currency table
		$this->data['bcrumb'] = 'Home'; // Default breadcrumb
		$this->data['title'] = 'Dashboard'; // Default title
	}

	
	//Check Login 
	protected function checkLoggedIn()
	{
		if (!session()->get('loggedIn')) {
			return redirect()->to('back-pass/login');
		}
	}
	
	
	public function logout()
	{
		$this->session = session();
		$this->session->setTempdata('success', 'You have <strong>logged out</strong> successfully.', 1);
        $this->session->remove('logged_user');
        $this->session->remove('loggedIn', true);
		return redirect()->to('back-pass/login');
		$this->session->destroy();
		return redirect()->to('back-pass/login');
	}
}