<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SubjectAnswersModel;

class SubjectAnswers extends BaseController
{
    public function index()
    {
        $model = new SubjectAnswersModel();
        $data['subject_answers'] = $model->getAll();
        return view('admin/subject_answers/index', $data);
    }

    public function create()
    {
        return view('admin/subject_answers/create');
    }

    public function store()
    {
        $model = new SubjectAnswersModel();
        $data = [
            'subject' => $this->request->getPost('subject'),
            'answer'  => $this->request->getPost('answer'),
            'status'  => $this->request->getPost('status'),
        ];
        $model->save($data);
        return redirect()->to('/admin/subject_answers');
    }

    public function edit($id)
    {
        $model = new SubjectAnswersModel();
        $data['subject_answer'] = $model->getById($id);
        return view('admin/subject_answers/edit', $data);
    }

    public function update($id)
    {
        $model = new SubjectAnswersModel();
        $data = [
            'subject' => $this->request->getPost('subject'),
            'answer'  => $this->request->getPost('answer'),
            'status'  => $this->request->getPost('status'),
        ];
        $model->update($id, $data);
        return redirect()->to('/admin/subject_answers');
    }

    public function delete($id)
    {
        $model = new SubjectAnswersModel();
        $model->delete($id);
        return redirect()->to('/admin/subject_answers');
    }
}
