<?php

namespace App\Controllers\Admin\Api;

use App\Controllers\BaseController;
use App\Models\ItemTypeDefinitionsModel;
use App\Models\BlockItemTypeRelationshipsModel;
use App\Models\BlockDefinitionsModel;

class BlockItemTypesController extends BaseController
{
    protected $itemTypeDefinitions;
    protected $blockItemTypeRelationships;
    protected $blockDefinitions;

    public function __construct()
    {
        $this->itemTypeDefinitions = new ItemTypeDefinitionsModel();
        $this->blockItemTypeRelationships = new BlockItemTypeRelationshipsModel();
        $this->blockDefinitions = new BlockDefinitionsModel();
    }

    /**
     * Get available item types for a specific block
     * 
     * @param int $blockId
     * @return \CodeIgniter\HTTP\Response
     */
    public function getAvailableItemTypes($blockId)
    {
        try {
            // Get the block's definition
            $block = $this->blockDefinitions->find($blockId);
            if (!$block) {
                return $this->response->setStatusCode(404)->setJSON([
                    'error' => 'Block not found'
                ]);
            }

            // Get item types based on block definition
            $itemTypes = $this->itemTypeDefinitions
                ->getByBlockDefinition($block['definition_id']);

            return $this->response->setJSON($itemTypes);

        } catch (\Exception $e) {
            log_message('error', '[BlockItemTypes] Error getting item types: ' . $e->getMessage());
            return $this->response->setStatusCode(500)->setJSON([
                'error' => 'Internal server error'
            ]);
        }
    }

    /**
     * Get all available icons
     * 
     * @return \CodeIgniter\HTTP\Response
     */
    public function getIcons()
    {
        $bootstrapIcons = [
            'bi bi-alarm',
            'bi bi-app',
            'bi bi-archive',
            'bi bi-arrow-left',
            'bi bi-arrow-right',
            'bi bi-arrows-move',
            'bi bi-bag',
            'bi bi-bell',
            'bi bi-book',
            'bi bi-bookmark',
            'bi bi-box',
            'bi bi-briefcase',
            'bi bi-calendar',
            'bi bi-camera',
            'bi bi-card-text',
            'bi bi-chat',
            'bi bi-check',
            'bi bi-chevron-down',
            'bi bi-chevron-up',
            'bi bi-clock',
            'bi bi-cloud',
            'bi bi-code',
            'bi bi-cog',
            'bi bi-collection',
            'bi bi-cursor',
            'bi bi-dash',
            'bi bi-diagram-3',
            'bi bi-document',
            'bi bi-envelope',
            'bi bi-exclamation',
            'bi bi-eye',
            'bi bi-file',
            'bi bi-folder',
            'bi bi-gear',
            'bi bi-globe',
            'bi bi-graph-up',
            'bi bi-grid',
            'bi bi-heart',
            'bi bi-house',
            'bi bi-image',
            'bi bi-inbox',
            'bi bi-info',
            'bi bi-key',
            'bi bi-laptop',
            'bi bi-layers',
            'bi bi-lightning',
            'bi bi-link',
            'bi bi-list',
            'bi bi-lock',
            'bi bi-map',
            'bi bi-menu-button',
            'bi bi-mic',
            'bi bi-moon',
            'bi bi-music-note',
            'bi bi-paperclip',
            'bi bi-pencil',
            'bi bi-people',
            'bi bi-person',
            'bi bi-phone',
            'bi bi-pin',
            'bi bi-play',
            'bi bi-plus',
            'bi bi-power',
            'bi bi-printer',
            'bi bi-question',
            'bi bi-reply',
            'bi bi-search',
            'bi bi-shield',
            'bi bi-shop',
            'bi bi-star',
            'bi bi-sun',
            'bi bi-table',
            'bi bi-tag',
            'bi bi-tools',
            'bi bi-trash',
            'bi bi-trophy',
            'bi bi-truck',
            'bi bi-upload',
            'bi bi-wallet',
            'bi bi-water',
            'bi bi-wifi',
            'bi bi-window',
            'bi bi-x'
        ];

        return $this->response->setJSON($bootstrapIcons);
    }
}