<?php

namespace Config;

use CodeIgniter\Config\BaseConfig;
use CodeIgniter\Validation\StrictRules\CreditCardRules;
use CodeIgniter\Validation\StrictRules\FileRules;
use CodeIgniter\Validation\StrictRules\FormatRules;
use CodeIgniter\Validation\StrictRules\Rules;

class Validation extends BaseConfig
{
    // --------------------------------------------------------------------
    // Setup
    // --------------------------------------------------------------------

    /**
     * Stores the classes that contain the
     * rules that are available.
     *
     * @var list<string>
     */
    public array $ruleSets = [
        Rules::class,
        FormatRules::class,
        FileRules::class,
        CreditCardRules::class,
    ];

    /**
     * Specifies the views that are used to display the
     * errors.
     *
     * @var array<string, string>
     */
    public array $templates = [
        'list'   => 'CodeIgniter\Validation\Views\list',
        'single' => 'CodeIgniter\Validation\Views\single',
    ];

    // --------------------------------------------------------------------
    // Rules
    // --------------------------------------------------------------------
	/**  Registration Form Rules **/
	public $userRegister = [
		'first_name'          	 => ['label' => 'First Name', 'rules' => 'required|min_length[3]|max_length[50]'],
		'last_name'          	 => ['label' => 'Other Name', 'rules' => 'required|min_length[3]|max_length[50]'],
        'email'          	 	 => ['label' => 'Email', 'rules' => 'required|min_length[5]|max_length[100]|valid_email|is_unique[users.email]'],
		'password'		 	 	 => ['label' => 'Password', 'rules' => 'required|min_length[8]|max_length[20]|alpha_numeric_punct'],
		'cpass'				 	 => ['label' => 'Confirm Password', 'rules' => 'required|matches[password]'],
	];
	
	public $userRegister_errors = [
		'first_name'        => [
									'required' 		=> 'Please enter First Name.',
									'min_length' 	=> 'Too short!! Name must be atleast 3 characters long.',
								],
		'last_name'         => [
									'required' 		=> 'Please enter Other Names.',
									'min_length' 	=> 'Too short!! Name must be atleast 3 characters long.',
								],								
		'email'          	=> [
									'required' 		=> 'Enter your Email.',
									'is_unique'		=> 'Email already exists. Try another',
									'valid_email' 	=> 'Please enter a valid email address.',
								],
		'password'		    => 	[
									'required' 		=> 'Enter your Password.',
									'min_length' 	=> 'Password must be atleast 8 digits.',
									'alpha_numeric_punct' => 'Password must contain alpha numeric'
								],					
		'cpass'				=>	[
									'required' 	=> 'Re-enter your password.',
									'matches' 	=> 'Confirm password and password must be same.'
								],					
		
	];
}
