<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Front\FrontPages::index');

$routes->get('search', 'Front\FrontPages::searchResults');
$routes->post('search', 'Front\FrontPages::searchResults');
$routes->get('search-page', 'Front\FrontPages::searchResultsPage');
$routes->post('search-page', 'Front\FrontPages::searchResultsPage');
// Banking Pages
$routes->get('personal', 'Front\FrontPages::personalPage');
$routes->get('business', 'Front\FrontPages::businessPage');
$routes->get('forex', 'Front\FrontPages::forexPage');
$routes->get('contact-us', 'Front\FrontPages::contactUs');
$routes->post('contact-us/submit', 'Front\FrontPages::submitContact');
$routes->post('contact-us', 'Front\FrontPages::submitContact');  // Keep this for backward compatibility
$routes->get('ways-to-bank', 'Front\FrontPages::waysToBankPage');
// Add these routes to your routes configuration
// About Us & Corporate Pages
$routes->get('corporate-social-responsibility', 'Front\FrontPages::corporateSocialResponsibility');
$routes->get('corporate-governance', 'Front\FrontPages::corporateGovernance');
$routes->get('board-of-directors', 'Front\FrontPages::boardOfDirectors');
$routes->get('management-team', 'Front\FrontPages::managementTeam');
$routes->get('about-us', 'Front\FrontPages::aboutUs');
// Service Overview Pages
$routes->get('saving-accounts', 'Front\FrontPages::savingAccountsOverview');
$routes->get('loan-accounts', 'Front\FrontPages::loanAccountsOverview');
$routes->get('loan-calculator', 'Front\FrontPages::loanCalculator');
$routes->get('money-transfer', 'Front\FrontPages::moneyTransfers');
$routes->get('open-account', 'Front\FrontPages::openAccount');
// Banking service routes
$routes->get('personal/(:any)', 'Front\Services::index/$1');
$routes->get('business/(:any)', 'Front\Services::index/$1');
$routes->get('team/(:any)', 'Front\FrontPages::teamPageTemplate/$1');

// Post and Blog routes
$routes->get('news', 'Front\FrontPosts::allNews');
$routes->get('news/(:any)', 'Front\FrontPosts::newsArticle/$1');
$routes->get('page/(:any)', 'Front\FrontPages::singleFrontPage/$1');
$routes->get('posts', 'Front\FrontPages::index');
$routes->get('posts/(:any)/(:any)', 'Front\FrontPages::productSinglePage/$1/$2');
$routes->get('posts/(:any)', 'Front\FrontPages::mainPageCategory/$1');
$routes->get('tags/tag/(:any)', 'Front\FrontPages::tagPosts/$1');


$routes->get('faqs-strategic-transitioning', 'Front\FrontPages::faqsStrategicTransitioning'); 
$routes->get('downloads', 'Front\FrontPages::downloadsPage'); 
// Download pages routes
$routes->get('annual-reports', 'Front\FrontPages::annualReports');
$routes->get('downloads/annual-reports', 'Front\FrontPages::annualReports'); // Alternative URL
$routes->get('bids-tenders', 'Front\FrontPages::bidsTenders');
$routes->get('downloads/bids-tenders', 'Front\FrontPages:::bidsTenders'); // Alternative URL
$routes->get('careers', 'Front\FrontPages::careersPage'); 

$routes->get('back-pass/login', 'Auth\Login::index');
$routes->post('user/login', 'Auth\Login::login');
$routes->get('verify-otp/(:any)', 'Auth\Login::verifyOTP/$1');
$routes->post('verify-otp/(:any)', 'Auth\Login::verifyOTP/$1');
$routes->get('forgot-password', 'Auth\Login::forgotPassword');
$routes->post('forgot-password', 'Auth\Login::forgotPassword');
$routes->get('password/reset/done=(:any)', 'Auth\Login::sentPwd/$1');
$routes->get('password/reset=(:any)', 'Auth\Login::resetPassword/$1');
$routes->post('new/password', 'Auth\Login::updatePassword');
$routes->get('user/activate/(:any)', 'Auth\Register::activate/$1');
$routes->post('user/activate/(:any)', 'Auth\Register::activate/$1');
$routes->get('thanks', 'Auth\Register::thx');
$routes->get('logout', 'Auth\AuthController::logout');